/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.pulley;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftVisual;
import com.simibubi.create.content.processing.burner.ScrollInstance;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.SectionTrackedVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.math.MoreMath;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.util.SmartRecycler;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class AbstractPulleyVisual<T extends KineticBlockEntity>
extends ShaftVisual<T>
implements SimpleDynamicVisual {
    private final ScrollInstance coil;
    private final TransformedInstance magnet;
    private final SmartRecycler<Boolean, TransformedInstance> rope;
    protected final class_2350 rotatingAbout;
    protected final class_7833 rotationAxis;
    private final LightCache lightCache = new LightCache();
    private float offset;

    public AbstractPulleyVisual(VisualizationContext dispatcher, T blockEntity, float partialTick) {
        super(dispatcher, blockEntity, partialTick);
        this.rotatingAbout = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.rotationAxis());
        this.rotationAxis = class_7833.method_46356((Vector3f)this.rotatingAbout.method_23955());
        float blockStateAngle = AngleHelper.horizontalAngle((class_2350)this.rotatingAbout);
        Quaternionf rotation = new Quaternionf().rotationY((float)Math.PI / 180 * blockStateAngle);
        this.coil = ((ScrollInstance)this.getCoilModel().createInstance()).rotation((Quaternionfc)rotation).position((class_2382)this.getVisualPosition()).setSpriteShift(this.getCoilAnimation());
        this.coil.setChanged();
        this.magnet = (TransformedInstance)this.magnetInstancer().createInstance();
        this.rope = new SmartRecycler(b -> b != false ? (TransformedInstance)this.getHalfRopeModel().createInstance() : (TransformedInstance)this.getRopeModel().createInstance());
        this.updateOffset(partialTick);
        this.updateLight(partialTick);
        this.animate();
    }

    public void setSectionCollector(SectionTrackedVisual.SectionCollector sectionCollector) {
        super.setSectionCollector(sectionCollector);
        this.lightCache.updateSections();
    }

    protected abstract Instancer<TransformedInstance> getRopeModel();

    protected abstract Instancer<TransformedInstance> getMagnetModel();

    protected abstract Instancer<TransformedInstance> getHalfMagnetModel();

    protected abstract Instancer<ScrollInstance> getCoilModel();

    protected abstract Instancer<TransformedInstance> getHalfRopeModel();

    protected abstract float getOffset(float var1);

    protected abstract boolean isRunning();

    protected abstract SpriteShiftEntry getCoilAnimation();

    private Instancer<TransformedInstance> magnetInstancer() {
        return this.offset > 0.25f ? this.getMagnetModel() : this.getHalfMagnetModel();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.updateOffset(ctx.partialTick());
        this.animate();
    }

    private void animate() {
        this.coil.offsetV = -this.offset;
        this.coil.setChanged();
        this.magnet.setVisible(this.isRunning() || this.offset == 0.0f);
        this.magnetInstancer().stealInstance((Instance)this.magnet);
        ((TransformedInstance)this.magnet.setIdentityTransform().translate((class_2382)this.getVisualPosition())).translate(0.0f, -this.offset, 0.0f).light(this.lightCache.getPackedLight(Math.max(0, class_3532.method_15375((float)this.offset)))).setChanged();
        this.rope.resetCount();
        if (this.shouldRenderHalfRope()) {
            float f = this.offset % 1.0f;
            float halfRopeNudge = f > 0.75f ? f - 1.0f : f;
            ((TransformedInstance)((TransformedInstance)this.rope.get((Object)true)).setIdentityTransform().translate((class_2382)this.getVisualPosition())).translate(0.0f, -halfRopeNudge, 0.0f).light(this.lightCache.getPackedLight(0)).setChanged();
        }
        if (this.isRunning()) {
            int neededRopeCount = this.getNeededRopeCount();
            for (int i = 0; i < neededRopeCount; ++i) {
                ((TransformedInstance)((TransformedInstance)this.rope.get((Object)false)).setIdentityTransform().translate((class_2382)this.getVisualPosition())).translate(0.0f, -this.offset + (float)i + 1.0f, 0.0f).light(this.lightCache.getPackedLight(neededRopeCount - 1 - i)).setChanged();
            }
        }
        this.rope.discardExtra();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.coil});
        this.lightCache.update();
    }

    private void updateOffset(float pt) {
        this.offset = this.getOffset(pt);
        this.lightCache.setSize(class_3532.method_15386((float)this.offset) + 2);
    }

    private int getNeededRopeCount() {
        return Math.max(0, class_3532.method_15386((float)(this.offset - 1.25f)));
    }

    private boolean shouldRenderHalfRope() {
        float f = this.offset % 1.0f;
        return this.offset > 0.75f && (f < 0.25f || f > 0.75f);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.coil);
        consumer.accept((Instance)this.magnet);
    }

    @Override
    protected void _delete() {
        super._delete();
        this.coil.delete();
        this.magnet.delete();
        this.rope.delete();
    }

    private class LightCache {
        private final ByteList data = new ByteArrayList();
        private final LongSet sections = new LongOpenHashSet();
        private final class_2338.class_2339 mutablePos = new class_2338.class_2339();
        private int sectionCount;

        private LightCache() {
        }

        public void setSize(int size) {
            if (size != this.data.size()) {
                this.data.size(size);
                this.update();
                int sectionCount = MoreMath.ceilingDiv((int)(size + 15 - AbstractPulleyVisual.this.pos.method_10264() + AbstractPulleyVisual.this.pos.method_10264() / 4 * 4), (int)16);
                if (sectionCount != this.sectionCount) {
                    this.sectionCount = sectionCount;
                    this.sections.clear();
                    int sectionX = class_4076.method_18675((int)AbstractPulleyVisual.this.pos.method_10263());
                    int sectionY = class_4076.method_18675((int)AbstractPulleyVisual.this.pos.method_10264());
                    int sectionZ = class_4076.method_18675((int)AbstractPulleyVisual.this.pos.method_10260());
                    for (int i = 0; i < sectionCount; ++i) {
                        this.sections.add(class_4076.method_18685((int)sectionX, (int)(sectionY - i), (int)sectionZ));
                    }
                    if (AbstractPulleyVisual.this.lightSections != null) {
                        this.updateSections();
                    }
                }
            }
        }

        public void updateSections() {
            AbstractPulleyVisual.this.lightSections.sections(this.sections);
        }

        public void update() {
            this.mutablePos.method_10101((class_2382)AbstractPulleyVisual.this.pos);
            for (int i = 0; i < this.data.size(); ++i) {
                int blockLight = AbstractPulleyVisual.this.level.method_8314(class_1944.field_9282, (class_2338)this.mutablePos);
                int skyLight = AbstractPulleyVisual.this.level.method_8314(class_1944.field_9284, (class_2338)this.mutablePos);
                int light = (skyLight & 0xF) << 4 | blockLight & 0xF;
                this.data.set(i, (byte)light);
                this.mutablePos.method_10098(class_2350.field_11033);
            }
        }

        public int getPackedLight(int offset) {
            if (offset < 0 || offset >= this.data.size()) {
                return 0;
            }
            int light = Byte.toUnsignedInt(this.data.getByte(offset));
            int blockLight = light & 0xF;
            int skyLight = light >>> 4 & 0xF;
            return class_765.method_23687((int)blockLight, (int)skyLight);
        }
    }
}

